package nestedstate;

import java.util.*;
import nestedstate.tools.*;

/**
* This class models a State. A state has a name and entry /exit actions.
* Further state also contains a dispatch mechanism for incoming events.
*/
public abstract class State
{
        private String name;        
        NodeState parent = null;
        
        /**
        * Initilizes a stateobject with name s.
        * @param s The name of the new state
        */
        public State(String s) 
        { 
                setName(s); 
        }
        
        void setParent(NodeState s) { parent = s; }
        NodeState getParent() { return parent; }
        
        public void setName(String s) { name = s; }
        public String getName() { return name; }
        
        
        /**
        * Convenience method that returns the name of this state.
        */
        public String toString()
        {
                return getName();
        }
        
        /**
        * Adds a transition with this state as source and parameter to as a
        * target. 
        * @param trigger The event that triggers the transition
        * @param to The target leafstate.
        * @param action The associated action
        */
        public abstract void addTransition(LeafState to,
                                           FSMEvent trigger,          
                                           FSMAction action);
        /**
        * Adds a transition with this state as source and parameter to as a
        * target. 
        * @param trigger The event that triggers the transition
        * @param to The target nodestate.
        * @param action The associated action
        */
        public abstract void addTransition(NodeState to,
                                           FSMEvent trigger,          
                                           FSMAction action);

        /**
        * Dispatch an event.
        * @param trigger The event that needs to be dispatched. The correct 
        * transition is located and than executed.
        * @param data Some additional data that may be needed by the action
        * @param fsmc The context in which the action is executed. This may be 
        * useful for retrieving global variables.
        */
        public abstract void dispatch(FSMEvent trigger, 
                                      Object data, 
                                      FSMContext fsmc);
        
        /**
        * Method to find out which events can be dispatched by this state.
        * @return A vector with the events 
        */
        public abstract Vector getEvents();
}
